#include "d_rat_point.h"
#include "hyperplane.h"
#include <LEDA/array.h>


main()
{

integer_vector A(3);

A[0] = A[1] = A[2] = 1;

hyperplane ha(A);


array<number> B(1,2);

B[1] = -1; B[2] = 0;

d_rat_point p(B,cartesian);


cout << "I expect 0: " << which_side(ha,p) << endl;

d_rat_point origin(2);


cout << "I expect 1: " << which_side(ha,origin) << endl;


d_rat_point n = p + p - p;

cout << "I expect 1 -1 0  " << n << endl;

array<integer_vector> N(1,1);

N[1] = make_direction_from_point(n);

array<d_rat_point> P(1,1);

P[1] = p;

hyperplane hb(P,N,origin,-1);

cout << "a hyperplane with normal n passing through p and having the origin on its negative side:  " << hb << endl;

}
