
#include <math.h>
#include <ctype.h>
#include "d_rat_point.h"
#include "integer_matrix.h"

//------------------------------------------------------------------------------
// rat_points :  points with rational (homogeneous) coordinates
//------------------------------------------------------------------------------





ostream& operator<<(ostream& out, const d_rat_point& p)
{ out << "(" ;
  for(int i = 0; i <= p.dim(); i++) out << p[i] << (i < p.dim()? ",":"");
  out << ")";
  return out;
 } 

istream& operator>>(istream& in, d_rat_point& p) 
{ /* Let d be the current dimension of p. I read d numbers and make
them the cartesian coordinates of a point which I assign to d. Note that
this is not(!!) the format which I write with << */
  int d = p.dim();
  array<number> coord(1,d);
  for (int i = 1;i<=d;i++) in >> coord[i];
  p = d_rat_point(coord,cartesian);
  return in; 

 } 



d_rat_point operator/(const d_rat_point & p, number n)
{ 
d_rat_point result(p.dim());
number* A = result.ptr()->coordinates;
A[0] = p.ptr()->coordinates[0] * n;
for (int i =1; i<= p.dim(); i++) 
     A[i] = p.ptr()->coordinates[i];
return result;
}

d_rat_point operator+(const d_rat_point& a, const d_rat_point &b)
{array<number> result(0,a.dim());

if (a.dim() != b.dim()) error_handler(1,"d_rat_point: cannot add points of different dimension");

result[0] = a[0] * b[0];
number aw = a[0];
number bw = b[0];

for (int i = 1; i <= a.dim(); i++) result[i] = a[i]*bw + b[i]*aw;

return d_rat_point(result,homogeneous);
}
 
d_rat_point& d_rat_point::operator+=(const d_rat_point& b)
{
int d = dim();
if (d != b.dim()) error_handler(1,"d_rat_point: cannot += points of different dimension");

d_rat_point_rep* rep_ptr = new d_rat_point_rep(d);

number aw = ptr()->coordinates[0];
number bw = b[0];

for (int i = 1; i <= d; i++) 
{ number ai = ptr()->coordinates[i]; 
rep_ptr->coordinates[i] = ai * bw + b[i]*aw;
}

rep_ptr->coordinates[0] = aw * bw;

PTR = rep_ptr;

return *this;
}

d_rat_point& d_rat_point::operator-=(const d_rat_point& b)
{
int d = dim();
if (d != b.dim()) error_handler(1,"d_rat_point: cannot += points of different dimension");

d_rat_point_rep* rep_ptr = new d_rat_point_rep(d);

number aw = ptr()->coordinates[0];
number bw = b[0];

for (int i = 1; i <= d; i++) 
{ number ai = ptr()->coordinates[i]; 
rep_ptr->coordinates[i] = ai * bw - b[i]*aw;
}

rep_ptr->coordinates[0] = aw * bw;

PTR = rep_ptr;

return *this;
}

d_rat_point operator-(const d_rat_point& a, const d_rat_point &b)
{int dimension = a.dim();
integer_vector result(dimension + 1    );

if (dimension != b.dim()) error_handler(1,"d_rat_point: cannot subtract points of different dimension");

result[0] = a[0] * b[0];
number aw = a[0];
number bw = b[0];

for (int i = 1; i<= dimension; i++ ) result[i] = a[i]*bw - b[i]*aw;

return d_rat_point(dimension,result);
}
 
integer_vector minus(const d_rat_point& a, const d_rat_point &b)
{integer_vector result(a.dim());

if (a.dim() != b.dim()) error_handler(1,"d_rat_point: cannot subtract points of different dimension");

number aw = a[0];
number bw = b[0];



for (int i = 1; i<= a.dim(); i++ ) result[i-1] = a[i]*bw - b[i]*aw;

return result;
}
 


int compare_help(const d_rat_point& a, const d_rat_point& b)
{ 
//  d_rat_point::cmp_count++;


if (a.dim() != b.dim()) 
{ cout << "first point has dim  " <<a.dim() <<" second point  "<<b.dim(); newline;
error_handler(1,"d_rat_point: cannot compare points of different dimension");
}


int signa0 = (a[0] > 0? 1 : -1);
int signb0 = (b[0] > 0? 1: -1);
int s = signa0 * signb0;


for (int i = 1;i <= a.dim(); i++ )
    {
    number aibw = a[i]*b[0];
    number biaw = b[i]*a[0];
    if (aibw > biaw) return  s;
    if (aibw < biaw) return -s;
    }

   
    return 0;
}

integer_vector make_direction_from_point(const d_rat_point & p)
/*{\Mfuncl returns the integer vector with entries $p[1]$ to
$p[d]$ }*/
{ integer_vector result(p.dim());
for (int i = 0; i < p.dim(); i++) result[i] = p[i+1];
return result;
}



int orientation(const array<d_rat_point> & A)
{/* we set up a matrix whose columns correspond to the homogeneous
coordinates of the points in A and return
the determinant of this matrix  */  
 int d = A.high() - A.low(); // A contains d+1 points
 integer_matrix M(d+1,d+1);
 
 int low = A.low();
 for (int i = 0; i <= d; i++)
   for (int j = 0; j <= d; j++) M(i,j) = A[low + i][j];

 number det = determinant(M);

 if (det > 0) return 1;
 if (det < 0) return -1;
 return 0;


  
}


int incircle(const array<d_rat_point> & A,const d_rat_point &x)
/*{determines whether the point $x$ lies inside (= -1), on (= 0),
or outside (= +1) the circle defined by the points in $A$, where $A$
consists of $d+1$ $d$-dimensional points }*/
{/* we use projection onto the paraboloid of revolution, i.e., the points are
lifted to the paraboloid (this makes the d+1th coordinate equal to
the sum of the squares of the cartesian coordinates) and the orientation
test is applied to the lifted points. The lifted point has homogeneous
coordinates (x0^2,x1*x0,...,xd*x0,\sum xi^2) */
 int d = A.high() - A.low(); // A contains d+1 points
 integer_matrix M(d+2,d+2);
 
 int low = A.low();

 for (int i = 0; i <= d; i++)
     { 
     number Sum = 0;
     number x0 = A[low+i][0];
     M(i,0) = x0*x0;
     for (int j = 1; j <= d; j++) 
	 {number xj = A[low + i][j];
          M(i,j) = xj * x0;
          Sum += xj*xj;
	 }
     M(i,d+1) = Sum;
     }
 number Sum = 0;
 number x0 = x[0];
 M(d+1,0) = x0*x0;
     for (int j = 1; j <= d; j++) 
	 {number xj = x[j];
          M(d+1,j) = xj * x0;
          Sum += xj*xj;
	 }
 M(d+1,d+1) = Sum;
     

 number det = determinant(M);

 if (det > 0) return 1;
 if (det < 0) return -1;
 return 0;
}




bool is_contained_in_linear_hull(const array< d_rat_point>& A,d_rat_point x)
{/* x is contained in the linear hull of A if x is a linear combination of
the points in A, i.e., if the system M * lambda = x has a solution where the
columns of M consist of the cartesian coordinates of the points in A. Since
scaling of points has no effect on linear dependency we may forget about
the division by the 0-th coordinate */

int low = A.low() ;
int k = A.high() - low + 1; // A contains k points
int d = A[A.low()].dim();
integer_matrix M(d,k);
integer_vector b(d);
for (int i = 1; i <= d; i++)
     {b[i -1] = x[i];
     for (int j = 0; j < k; j++) M(i -1 ,j) = A[low  + j][i];
     }

 return solvable(M,b);
  
}

 
bool is_contained_in_affine_hull(const array< d_rat_point>& A,d_rat_point x)
{/* Let A consist of points p0,p1,...,pk. Then x is contained in the affine 
hull of A if x-p0 is contained in the linear hull of p1-p0,...pk-p0. We can
therefore proceed as described above. If k = 0 then we return true
if x is equal to the single point in A */

int low = A.low();
int k = A.high() - low ; // A contains k+ 1 points
int d = A[A.low()].dim();
if (k == 0) return (x == A[low]);
integer_matrix M(d,k);
integer_vector b(d);


d_rat_point x_minus_p0 = x - A[low];
 
for (int j = 1; j <= k; j++)
{d_rat_point pj_minus_p0 = A[low + j] - A[low];
 for (int i = 1; i <= d; i++)
     {b[i - 1] = x_minus_p0[i];
      M(i -1 ,j -1) = pj_minus_p0[i];
     }
}

 return solvable(M,b);
  
}
   

bool is_contained_in_simplex(const array< d_rat_point>& A,d_rat_point x)

{/* Let A consist of points p0,p1,...,pk. These points are assumed to be
affinely independent. We want to know whether x is contained in the convex 
hull of the points in A. If k = 0 then we return true
if x is equal to the single point in A. So  assume that k > 0. We fist check whether x is contained in the affine hull of the points in A. For this to be
the case x-p0 must be contained in the linear hull of p1-p0,...pk-p0. We solve
the linear system whose columns are the Euclidian coordinates of pi - p0 (multiplied by pi0p00)
and whose right hand side is x - p0 (multiplied by x0 * p00). We need that
lambdai pi0 p00 / (x0 p00) is non-negative for all i and that their sum is most 1. */

int low = A.low();
int k = A.high() - low ; // A contains k+ 1 points
int d = A[A.low()].dim();
if (k == 0) return (x == A[low]);

integer_matrix M(d,k);
integer_vector b(d);


d_rat_point x_minus_p0 = x - A[low];
 
for (int j = 1; j <= k; j++)
{d_rat_point pj_minus_p0 = A[low + j] - A[low];
 for (int i = 1; i <= d; i++)
     {b[i - 1] = x_minus_p0[i];
      M(i -1 ,j -1) = pj_minus_p0[i];
     }
}
number D;
integer_vector lambda;

if (linear_solver(M,b,lambda,D))
{  int sp00 = sign(A[A.low()][0]);
   int sx   = sign(x[0]);
   int sD = sign(D);
   number sum = 0;

  for (int i = 1; i <= k; i++)
	{if (sign(lambda[i-1])*sign(A[A.low()+i][0])*sx*sD < 0) return false; 
         sum += lambda[i-1]*A[A.low()+i][0];
	}
  if (sx*sD*sum > sx*sD*x[0]*D) return false;
  return true;

}

return false;
  
}




bool linearly_independent(const array<d_rat_point>& A)
{
/* a set of points is linearly independent if their linear rank is
equal to the number of points in the set */
return (linear_rank(A) == (A.high() - A.low() +1));
}
   

int  linear_rank(const array<d_rat_point>& A)
{
/* we set up a matrix having the cartesian coordinates of the 
points in A as its colums. The linear rank is the rank of this matrix.
Since the rank of a matrix does not change under multiplication
 of a row with a constant we may also use the homogeneous
coordinates 1 to d of the points in A */
int low = A.low();
int k = A.high() - low +1; // A contains k points
int d = A[A.low()].dim();
integer_matrix M(d,k);
 

 for (int i = 0; i < d  ; i++)
   for (int j = 0; j < k; j++) M(i,j) = A[low + j][i + 1];

 return rank(M);
  
}
   
bool affinely_independent(const array<d_rat_point>& A)
{ /* a set of points p0,p1,...,pk is affinely independent if their affine
rank is equal to the number of points in A minus 1 */


return( affine_rank(A) == (A.high() - A.low()));



}
 
  
int affine_rank(const array<d_rat_point>& A)
{ /* a affine rank of points p0,p1,...,pk is the linear rank of points
p1-p0,...,pk-p0. Now we proceed as above */


int low = A.low();
int high = A.high();
int k = high - low; // A contains k+1 points
if (k == 0) return 0;
int d = A[A.low()].dim();
integer_matrix M(d,k);
 


for (int j = 1; j <= k; j++){
  d_rat_point p = A[low+j]- A[low]; 
  for (int i = 1; i <= d; i++) M(i-1,j-1) = p[i];

 return rank(M);
 


}
}
 



list<d_rat_point> linear_base(const array<d_rat_point>& A)
/*{/Mfunc computes a basis of the linear space spanned by the points in $A$}*/

{

cout << "linear base: not yet implemented";

list<d_rat_point> L;
return L;

	}






