#include <db.h>
#include <cgi.h>
#include <string.h>
#include <stdlib.h>

#include "globals.h"

/* declarations missing from cgi.h */
void rtrim(char *);

int main(int argc, char **argv)
{
  DB *dbp;
  DBC *cursorp;
  DBT key, value;
  FILE *fp;
  char linebuf[LINESIZE];
  char *song, *votes;
  char *selfurl;
  int ret,vote;

  cgi_init();
  cgi_init_headers();
  selfurl=getenv("SCRIPT_NAME");

  puts("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n"
       "<html>\n"
       "<head>");
  printf("<META http-equiv=\"refresh\" content=\"150; URL=%s\">\n",selfurl);
  puts("<META http-equiv=\"content-type\" content=\"text/html; charset=windows-1250\">\n"
       "<title>RTPJukeBox Vote Page</title>\n"
       "</head>\n"
       "<body>\n"
       "<H1>Welcome to the RTPJukeBox</H1>\n"
       "The URL of the stream is <a href=\"rtp://225.2.1.5:4420\">rtp://225.2.1.5:4420</a> .<br>\n"
       "<hr>\n");
  if ((ret = db_create(&dbp, NULL, 0)) != 0)
    cgi_fatal("db_create failed");
  if ((ret = dbp->open(dbp, playlistfile, NULL, DB_HASH, 0, 0)) != 0)
    cgi_fatal("db_open failed");

  if (cgi_process_form() != NULL) {
    fp=fopen(staticfile, "a");
    while((song=cgi_param_multiple("vote")) != NULL) {
      memset(&key, 0 ,sizeof(DBT));
      memset(&value, 0 ,sizeof(DBT));
      key.data=song;
      key.size=strlen(song)+1;
      if (dbp->get(dbp, NULL, &key, &value, 0) == DB_NOTFOUND) {
        vote=1;
      } else {
	vote=atoi(value.data)+1;
      }
      ret=snprintf(linebuf, LINESIZE, "%d", vote);
      memset(&value, 0 ,sizeof(DBT));
      value.data=linebuf;
      value.size=ret+1;
      dbp->put(dbp, NULL, &key, &value, 0);
      fprintf(fp, "%s\n", song);
    }
    fclose(fp);
  }

  puts("<H2>Next Songs:</H2>\n");
  if ((fp = fopen(staticfile, "r")) != NULL) {
    while (fgets(linebuf, LINESIZE, fp) != NULL)
      printf("%s<br>\n", linebuf);
    fclose(fp);
  }
  puts("<hr>");

  puts("<H2>Titels available</H2>");
  printf("<form action=\"%s\" method=\"post\">\n",selfurl);
  printf("<select name=\"vote\" size=%d>\n",RECENTLINES);
  dbp->cursor(dbp, NULL, &cursorp, 0);
  memset(&key, 0 ,sizeof(DBT));
  memset(&value, 0 ,sizeof(DBT));
  while ((ret = cursorp->c_get(cursorp, &key, &value, DB_NEXT)) == 0) {
    rtrim(key.data);
    song=key.data;
    rtrim(value.data);
    votes=value.data;
    printf("<option value=\"%s\">%s (current votes:%s)</option>\n",song,song,votes);
  }
  puts("</select><br>\n"
       "<input type=\"submit\" value=\"vote\">\n"
       "<H2>Last played</H2>\n");
  if ((fp = fopen(recentlyplayedfile, "r")) != NULL) {
    while (fgets(linebuf, LINESIZE, fp) != NULL) {
      rtrim(linebuf);
      printf("<input type=\"radio\" name=\"vote\" value=\"%s\"", linebuf);
      memset(&key, 0 ,sizeof(DBT));
      memset(&value, 0 ,sizeof(DBT));
      key.data=linebuf;
      key.size=strlen(linebuf)+1;
      if (dbp->get(dbp, NULL, &key, &value, 0) == DB_NOTFOUND) {
        votes=NULL;
	printf(" disabled");
      } else {
        rtrim(value.data);
	votes=value.data;
      }
      printf(">%s",linebuf);
      if (votes != NULL)
        printf(" (current votes: %s)",votes);
      puts("<br>\n");
    }
    fclose(fp);
  }

  dbp->close(dbp, 0);
  puts("<input type=\"submit\" value=\"vote\">\n"
       "</form>\n"
       "</body>\n"
       "</html>");
  cgi_end();
  return 0;
}
